<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require 'vendor/autoload.php';

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->to) &&
    !empty($data->subject) &&
    !empty($data->body)
) {
    $mail = new PHPMailer(true);

    try {
        //Server settings
        $mail->isSMTP();                                            //Send using SMTP
        $mail->Host = 'arqana.shop';                     //Set the SMTP server to send through
        $mail->SMTPAuth = true;                                   //Enable SMTP authentication
        $mail->Username = 'orders@arqana.shop';                     //SMTP username
        $mail->Password = '@#Orders2025';                               //SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;         //Enable implicit TLS encryption or PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = 465;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

        //Recipients
        $mail->setFrom('orders@arqana.shop', 'Mailer');
        $mail->addAddress($data->to);     //Add a recipient

        //Content
        $mail->isHTML(true);                                  //Set email format to HTML
        $mail->Subject = $data->subject;
        $mail->Body = $data->body;
        $mail->AltBody = strip_tags($data->body);

        $mail->send();
        http_response_code(200);
        echo json_encode(array("message" => "Email has been sent.", "success" => true));
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(array("message" => "Message could not be sent. Mailer Error: {$mail->ErrorInfo}", "success" => false));
    }
} else {
    http_response_code(400);
    echo json_encode(array("message" => "Unable to send email. Data is incomplete.", "success" => false));
}
