<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\BeyondCorp;

class GoogleCloudBeyondcorpAppconnectorsV1AppConnector extends \Google\Model
{
  /**
   * Default value. This value is unused.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * AppConnector is being created.
   */
  public const STATE_CREATING = 'CREATING';
  /**
   * AppConnector has been created.
   */
  public const STATE_CREATED = 'CREATED';
  /**
   * AppConnector's configuration is being updated.
   */
  public const STATE_UPDATING = 'UPDATING';
  /**
   * AppConnector is being deleted.
   */
  public const STATE_DELETING = 'DELETING';
  /**
   * AppConnector is down and may be restored in the future. This happens when
   * CCFE sends ProjectState = OFF.
   */
  public const STATE_DOWN = 'DOWN';
  /**
   * Output only. Timestamp when the resource was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * Optional. An arbitrary user-provided name for the AppConnector. Cannot
   * exceed 64 characters.
   *
   * @var string
   */
  public $displayName;
  /**
   * Optional. Resource labels to represent user provided metadata.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Required. Unique resource name of the AppConnector. The name is ignored
   * when creating a AppConnector.
   *
   * @var string
   */
  public $name;
  protected $principalInfoType = GoogleCloudBeyondcorpAppconnectorsV1AppConnectorPrincipalInfo::class;
  protected $principalInfoDataType = '';
  protected $resourceInfoType = GoogleCloudBeyondcorpAppconnectorsV1ResourceInfo::class;
  protected $resourceInfoDataType = '';
  /**
   * Output only. The current state of the AppConnector.
   *
   * @var string
   */
  public $state;
  /**
   * Output only. A unique identifier for the instance generated by the system.
   *
   * @var string
   */
  public $uid;
  /**
   * Output only. Timestamp when the resource was last modified.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Output only. Timestamp when the resource was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Optional. An arbitrary user-provided name for the AppConnector. Cannot
   * exceed 64 characters.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Optional. Resource labels to represent user provided metadata.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Required. Unique resource name of the AppConnector. The name is ignored
   * when creating a AppConnector.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Required. Principal information about the Identity of the AppConnector.
   *
   * @param GoogleCloudBeyondcorpAppconnectorsV1AppConnectorPrincipalInfo $principalInfo
   */
  public function setPrincipalInfo(GoogleCloudBeyondcorpAppconnectorsV1AppConnectorPrincipalInfo $principalInfo)
  {
    $this->principalInfo = $principalInfo;
  }
  /**
   * @return GoogleCloudBeyondcorpAppconnectorsV1AppConnectorPrincipalInfo
   */
  public function getPrincipalInfo()
  {
    return $this->principalInfo;
  }
  /**
   * Optional. Resource info of the connector.
   *
   * @param GoogleCloudBeyondcorpAppconnectorsV1ResourceInfo $resourceInfo
   */
  public function setResourceInfo(GoogleCloudBeyondcorpAppconnectorsV1ResourceInfo $resourceInfo)
  {
    $this->resourceInfo = $resourceInfo;
  }
  /**
   * @return GoogleCloudBeyondcorpAppconnectorsV1ResourceInfo
   */
  public function getResourceInfo()
  {
    return $this->resourceInfo;
  }
  /**
   * Output only. The current state of the AppConnector.
   *
   * Accepted values: STATE_UNSPECIFIED, CREATING, CREATED, UPDATING, DELETING,
   * DOWN
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * Output only. A unique identifier for the instance generated by the system.
   *
   * @param string $uid
   */
  public function setUid($uid)
  {
    $this->uid = $uid;
  }
  /**
   * @return string
   */
  public function getUid()
  {
    return $this->uid;
  }
  /**
   * Output only. Timestamp when the resource was last modified.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudBeyondcorpAppconnectorsV1AppConnector::class, 'Google_Service_BeyondCorp_GoogleCloudBeyondcorpAppconnectorsV1AppConnector');
