<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SearchConsole;

class SitesListResponse extends \Google\Collection
{
  protected $collection_key = 'siteEntry';
  protected $siteEntryType = WmxSite::class;
  protected $siteEntryDataType = 'array';

  /**
   * Contains permission level information about a Search Console site. For more
   * information, see [Permissions in Search
   * Console](https://support.google.com/webmasters/answer/2451999).
   *
   * @param WmxSite[] $siteEntry
   */
  public function setSiteEntry($siteEntry)
  {
    $this->siteEntry = $siteEntry;
  }
  /**
   * @return WmxSite[]
   */
  public function getSiteEntry()
  {
    return $this->siteEntry;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SitesListResponse::class, 'Google_Service_SearchConsole_SitesListResponse');
